using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using gov.va.med.vbecs.Common;
using REAGENTTYPEPARAMETER = gov.va.med.vbecs.Common.VbecsTables.ReagentTypeParameter;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmMaintainReagentMinLevels
	/// </summary>
	public class FrmMaintainReagentMinLevels : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		// Holds the existing Minimum Level values
		private Hashtable _existingLevels;
		private Hashtable _rowVersions;
		
		//Holds the ParameterGuids -- needed for ???
		private Hashtable _parameterGuids;

		// Holds the Reagent that have been changed and will be submitted.
		private ArrayList _changedReagents;
		
		// Initial value changes
		bool _enabled = false;
        		
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.GroupBox grpReagents;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.ListView lvReagents;
		private System.Windows.Forms.ColumnHeader colReagentType;
		private System.Windows.Forms.ColumnHeader colMinimumLevel;
		private System.Windows.Forms.GroupBox grpEditReagent;
		private System.Windows.Forms.Label lblReagentType;
		private System.Windows.Forms.Label lblMinimumStockLevel;
		private System.Windows.Forms.TextBox txtReagentType;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnSave;
		private System.Windows.Forms.PictureBox picImage;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updMinimumStockLevel;
		private System.ComponentModel.IContainer components = null;


		private System.Data.DataTable _dtExistingLevels = new System.Data.DataTable();

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmMaintainReagentMinLevels()
		{
			this.LockController.LockFunction = Common.LockFunctions.UC058MaintainReagentMinInventoryLevels;

			InitializeComponent();

			//Locking Check --- Since no minimum values may exist, we have to lockout the entire UC, to prevent 
			//Multiple users from making changes at the same time
			if (!this.LockUseCase())
			{
				this.DialogResult = DialogResult.Abort;
				this.Close();
				return;
			}

			SetComponentProperties();
		}


		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmMaintainReagentMinLevels));
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.picImage = new System.Windows.Forms.PictureBox();
			this.grpReagents = new System.Windows.Forms.GroupBox();
			this.lvReagents = new System.Windows.Forms.ListView();
			this.colReagentType = new System.Windows.Forms.ColumnHeader();
			this.colMinimumLevel = new System.Windows.Forms.ColumnHeader();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnSave = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpEditReagent = new System.Windows.Forms.GroupBox();
			this.updMinimumStockLevel = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.txtReagentType = new System.Windows.Forms.TextBox();
			this.lblMinimumStockLevel = new System.Windows.Forms.Label();
			this.lblReagentType = new System.Windows.Forms.Label();
			this.grpImage.SuspendLayout();
			this.grpReagents.SuspendLayout();
			this.grpEditReagent.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.updMinimumStockLevel)).BeginInit();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(428, 30);
			this.vbecsLogo1.TabIndex = 4;
			this.vbecsLogo1.Title = "Maintain Minimum Inventory Levels";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 477);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 6;
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.picImage);
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(56, 424);
			this.grpImage.TabIndex = 5;
			this.grpImage.TabStop = false;
			// 
			// picImage
			// 
			this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
			this.picImage.Location = new System.Drawing.Point(4, 12);
			this.picImage.Name = "picImage";
			this.picImage.Size = new System.Drawing.Size(45, 44);
			this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picImage.TabIndex = 1;
			this.picImage.TabStop = false;
			// 
			// grpReagents
			// 
			this.grpReagents.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReagents.Controls.Add(this.lvReagents);
			this.grpReagents.Location = new System.Drawing.Point(64, 32);
			this.grpReagents.Name = "grpReagents";
			this.grpReagents.Size = new System.Drawing.Size(352, 348);
			this.grpReagents.TabIndex = 0;
			this.grpReagents.TabStop = false;
			// 
			// lvReagents
			// 
			this.lvReagents.AccessibleDescription = "Reagents";
			this.lvReagents.AccessibleName = "Reagents";
			this.lvReagents.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvReagents.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						 this.colReagentType,
																						 this.colMinimumLevel});
			this.lvReagents.FullRowSelect = true;
			this.lvReagents.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
			this.lvReagents.HideSelection = false;
			this.lvReagents.Location = new System.Drawing.Point(8, 12);
			this.lvReagents.MultiSelect = false;
			this.lvReagents.Name = "lvReagents";
			this.lvReagents.Size = new System.Drawing.Size(336, 328);
			this.lvReagents.TabIndex = 0;
			this.lvReagents.View = System.Windows.Forms.View.Details;
			this.lvReagents.SelectedIndexChanged += new System.EventHandler(this.lvReagents_SelectedIndexChanged);
			// 
			// colReagentType
			// 
			this.colReagentType.Text = "Reagent Type";
			this.colReagentType.Width = 200;
			// 
			// colMinimumLevel
			// 
			this.colMinimumLevel.Text = "Minimum Stock Level";
			this.colMinimumLevel.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.colMinimumLevel.Width = 115;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
			this.btnOK.Location = new System.Drawing.Point(264, 464);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 2;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(344, 464);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 3;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// btnSave
			// 
			this.btnSave.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSave.EnabledButton = false;
			this.btnSave.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSave.Image = ((System.Drawing.Image)(resources.GetObject("btnSave.Image")));
			this.btnSave.Location = new System.Drawing.Point(256, 40);
			this.btnSave.Name = "btnSave";
			this.btnSave.Size = new System.Drawing.Size(75, 23);
			this.btnSave.TabIndex = 4;
			this.btnSave.Click += new System.EventHandler(this.btnSave_Click);
			// 
			// grpEditReagent
			// 
			this.grpEditReagent.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpEditReagent.Controls.Add(this.updMinimumStockLevel);
			this.grpEditReagent.Controls.Add(this.btnSave);
			this.grpEditReagent.Controls.Add(this.txtReagentType);
			this.grpEditReagent.Controls.Add(this.lblMinimumStockLevel);
			this.grpEditReagent.Controls.Add(this.lblReagentType);
			this.grpEditReagent.Location = new System.Drawing.Point(64, 384);
			this.grpEditReagent.Name = "grpEditReagent";
			this.grpEditReagent.Size = new System.Drawing.Size(352, 72);
			this.grpEditReagent.TabIndex = 1;
			this.grpEditReagent.TabStop = false;
			// 
			// updMinimumStockLevel
			// 
			this.updMinimumStockLevel.AccessibleDescription = "Minimum Stock Level";
			this.updMinimumStockLevel.AccessibleName = "Minimum Stock Level";
			this.updMinimumStockLevel.Location = new System.Drawing.Point(120, 40);
			this.updMinimumStockLevel.Maximum = new System.Decimal(new int[] {
																				 999,
																				 0,
																				 0,
																				 0});
			this.updMinimumStockLevel.Name = "updMinimumStockLevel";
			this.updMinimumStockLevel.Size = new System.Drawing.Size(56, 20);
			this.updMinimumStockLevel.TabIndex = 3;
			this.updMinimumStockLevel.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updMinimumStockLevel.Value = new System.Decimal(new int[] {
																			   0,
																			   0,
																			   0,
																			   0});
			this.updMinimumStockLevel.TextChanged += new System.EventHandler(this.updMinimumStockLevel_TextChanged);
			this.updMinimumStockLevel.Leave += new System.EventHandler(this.updMinimumStockLevel_Leave);
			this.updMinimumStockLevel.ValueChanged += new System.EventHandler(this.updMinimumStockLevel_TextChanged);
			// 
			// txtReagentType
			// 
			this.txtReagentType.AccessibleDescription = "Reagent Type";
			this.txtReagentType.AccessibleName = "Reagent Type";
			this.txtReagentType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtReagentType.Location = new System.Drawing.Point(120, 16);
			this.txtReagentType.Name = "txtReagentType";
			this.txtReagentType.ReadOnly = true;
			this.txtReagentType.Size = new System.Drawing.Size(212, 20);
			this.txtReagentType.TabIndex = 1;
			this.txtReagentType.Text = "";
			// 
			// lblMinimumStockLevel
			// 
			this.lblMinimumStockLevel.Location = new System.Drawing.Point(8, 40);
			this.lblMinimumStockLevel.Name = "lblMinimumStockLevel";
			this.lblMinimumStockLevel.Size = new System.Drawing.Size(116, 20);
			this.lblMinimumStockLevel.TabIndex = 2;
			this.lblMinimumStockLevel.Text = "Minimum Stock Level";
			this.lblMinimumStockLevel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblReagentType
			// 
			this.lblReagentType.Location = new System.Drawing.Point(8, 16);
			this.lblReagentType.Name = "lblReagentType";
			this.lblReagentType.Size = new System.Drawing.Size(116, 20);
			this.lblReagentType.TabIndex = 0;
			this.lblReagentType.Text = "Reagent Type";
			this.lblReagentType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// FrmMaintainReagentMinLevels
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(428, 493);
			this.Controls.Add(this.grpEditReagent);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpReagents);
			this.Controls.Add(this.grpImage);
			this.hlphelpChm.SetHelpKeyword(this, "Maintain_Minimum_Levels.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(428, 440);
			this.Name = "FrmMaintainReagentMinLevels";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Maintain Minimum Reagent Levels";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmMaintainReagentMinLevels_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.grpReagents, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpEditReagent, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpImage.ResumeLayout(false);
			this.grpReagents.ResumeLayout(false);
			this.grpEditReagent.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.updMinimumStockLevel)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion


		#region Methods

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/18/2003</CreationDate>
		///
		/// <summary>
		/// Private function to return indication of user's authority to access function
		/// </summary>
		/// <returns></returns>
		private bool HasAuthority()
		{
			return ThisUser.IsAuthorizedForFunction( Common.FunctionCode.MaintainMinimumLevels );
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}


		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC058.FrmMaintainReagentMinLevels());
			//
			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = false;
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.UC058.UpdateReagentType().ResString);
			//
			this.btnSave.Text = "&Update";
			this.btnSave.SetToolTip(Common.StrRes.Tooltips.UC058.UpdateReagentType().ResString);

			// Gets the Minimum values that have already been entered
			this._dtExistingLevels = BOL.ReagentType.GetExistingMinimumLevels(Common.LogonUser.LogonUserDivisionCode);

			this._changedReagents = new ArrayList();

			LoadLevels(this._dtExistingLevels);
			// Get the reagent types to populate the combo box
			DataTable dtReagentTypes = BOL.ReagentType.GetReagentTypes();
			PopulateListView(dtReagentTypes);
			this.btnSave.EnabledButton = false;
		}

		/// <summary>
		/// This method stores the existing Minimum Values and RowVersions in Hashtables.
		/// These Hashtables will later be used to construct the ReagentType objects.
		/// </summary>
		/// <developers>
		///		<developer>Carl Jensen</developer>
		/// </developers>
		/// <date>12/03/2002</date>
		private void LoadLevels(DataTable dtExistingLevels)
		{
			this._existingLevels = new Hashtable();
			this._rowVersions = new Hashtable();
			this._parameterGuids = new Hashtable();

			foreach (DataRow dr in dtExistingLevels.Rows)
			{
				int reagentID = (int) dr[Common.VbecsTables.ReagentTypeParameter.ReagentTypeId];
				short minimumLevel = (short) dr[Common.VbecsTables.ReagentTypeParameter.MinimumStockLevel];
				byte[] rowVersion = (byte[]) dr[Common.VbecsTables.ReagentTypeParameter.RowVersion];
				System.Guid parameterGuid = (System.Guid)dr[Common.VbecsTables.ReagentTypeParameter.ReagentTypeParameterGuid];

				this._existingLevels.Add(reagentID, minimumLevel);
				this._rowVersions.Add(reagentID, rowVersion);
				this._parameterGuids.Add(reagentID, parameterGuid);
			}
		}

		private void PopulateListView(DataTable dtReagentTypes)
		{
			foreach (DataRow dr in dtReagentTypes.Rows)
			{
				// get DB values and build reagent object
				int reagentID = (int) dr[Common.VbecsTables.ReagentType.ReagentTypeId];
				string reagentTypeName  = dr[Common.VbecsTables.ReagentType.ReagentTypeName].ToString();

				if (reagentID == 1 || reagentID == 3 || reagentID == 17 || reagentID == 18 || reagentID == 19 || reagentID == 38)
				{
					continue;
				}

				short minimumLevel = 0;
				if (this._existingLevels != null && this._existingLevels.ContainsKey(reagentID))
				{
					minimumLevel = (short) this._existingLevels[reagentID];
				}

				BOL.ReagentType reagent = new BOL.ReagentType(reagentID, reagentTypeName, minimumLevel);
				if (this._rowVersions != null && this._rowVersions.ContainsKey(reagentID))
				{
					reagent.RowVersion = (byte[]) this._rowVersions[reagentID];
				}			

				if (this._parameterGuids.ContainsKey(reagentID))
					reagent.ReagentTypeParameterGuid = (System.Guid)this._parameterGuids[reagentID];

				// Load the listview				
				string[] columns = new String[2];
				columns[0] = reagentTypeName;
				columns[1] = minimumLevel.ToString();
				
				ListViewItem lvi = new ListViewItem(columns);
				lvi.Tag = reagent;

				this.lvReagents.Items.Add(lvi);
			}
			//
			controls.VbecsFunction.SetColumnWidths(this.lvReagents);
			//
			if (this.lvReagents.Items.Count>0)
			{
				this.lvReagents.Items[0].Selected = true;
				lvReagents_SelectedIndexChanged(this,EventArgs.Empty);
			}
		}

		#endregion


		#region Events

		private void lvReagents_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (this.lvReagents.SelectedItems.Count > 0)
			{
				this.txtReagentType.Text = this.lvReagents.SelectedItems[0].Text;
				try
				{
					this.updMinimumStockLevel.Value = System.Convert.ToDecimal(this.lvReagents.SelectedItems[0].SubItems[1].Text);
				}
				catch(FormatException)
				{
					this.updMinimumStockLevel.Value = this.updMinimumStockLevel.Minimum;
				}
				this.updMinimumStockLevel.Select(0,this.updMinimumStockLevel.Value.ToString().Length);
				this.btnSave.EnabledButton = false;
				this.btnSave.SetToolTip(Common.StrRes.Tooltips.UC058.UpdateReagentType().ResString);
				// I commented this out because the user doesn't see a cursor if using the arrows to scroll through
				// the reagents.
				//this.updMinimumStockLevel.Focus();

			}
		}

		private void btnSave_Click(object sender, System.EventArgs e)
		{
			try
			{			
				this.btnOK.EnabledButton = true;
				//Setting the dirty variable of the vbecsbase form so that
				//if the user does not save before they exit the screen they
				//will be prompted and reminded that they have unsaved data
				//remaining.
				this.IsDirty=true;
				ListViewItem lvi = this.lvReagents.SelectedItems[0];
				BOL.ReagentType rType = (BOL.ReagentType) lvi.Tag;

				rType.MinimumStockLevel = (short) System.Math.Round(this.updMinimumStockLevel.Value);

				this.errError.SetVbecsError(this.updMinimumStockLevel, ""); // **** 508 Compliance ***
				this._changedReagents.Remove(rType);
				this._changedReagents.Add(rType);
				//
				lvi.SubItems[1].Text = rType.MinimumStockLevel.ToString();
				this.lvReagents.Refresh();
				//
				try
				{
					this.lvReagents.Items[this.lvReagents.SelectedIndices[0]+1].Selected = true;
				}
				catch (ArgumentOutOfRangeException)
				{
					this.lvReagents.Items[0].Selected = true;
				}
				this.updMinimumStockLevel.Focus();
				this.btnSave.EnabledButton = false;
			}
			catch (BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.updMinimumStockLevel, err.Message); // **** 508 Compliance ***
			}
			catch (Exception ex)
			{
				this.errError.SetVbecsError(this.updMinimumStockLevel, ex.Message); // **** 508 Compliance ***
			}
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			DialogResult saveResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("reagent definition"));
			if (saveResult == DialogResult.Yes)
			{
				try
				{
					foreach (BOL.ReagentType rType in this._changedReagents) 
					{
						// ToDo: should be using teh IsNew property, but the object isn't being 
						// implemented correctly now
						if (rType.RowVersion == null)
						{
							rType.InsertReagent(Common.UpdateFunction.UC058FrmMaintainReagentMinLevels);
						}
						else
						{
							rType.SaveReagentStockLevels(Common.UpdateFunction.UC058FrmMaintainReagentMinLevels);
						}
					}
					this.DialogResult = DialogResult.OK;
					//Setting the dirty variable to false so that the window
					//closing event will not show it's alert asking about unsaved
					//data remaining.
					this.IsDirty=false;
					this.Close();
				}
				catch (RowVersionException)
				{
					this.btnOK.RowVersionException = true;		//CR2077
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
					return;
				}
			}
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}

		private void updMinimumStockLevel_Leave(object sender, System.EventArgs e)
		{
			try
			{
				this.updMinimumStockLevel.Value = this.updMinimumStockLevel.Value;
				this.btnSave.EnabledButton = true;
				this.errError.SetVbecsError(updMinimumStockLevel, string.Empty); // **** 508 Compliance ***
				this.btnSave.SetToolTip(Common.StrRes.Tooltips.Common.OKToProceed().ResString);
			}
			catch(FormatException err)
			{
				this.btnSave.EnabledButton = false;
				this.errError.SetVbecsError(updMinimumStockLevel, err.Message); // **** 508 Compliance ***
				this.btnSave.SetToolTip(Common.StrRes.SysErrMsg.Common.RangeError("Minimum stock level",updMinimumStockLevel.Minimum,updMinimumStockLevel.Maximum).ResString);
			}
		}

		private void updMinimumStockLevel_TextChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (this.lvReagents.Items[0].Selected && _enabled == false) 
				{
					_enabled = true;
				}
				else
				{
					this.updMinimumStockLevel.Value = this.updMinimumStockLevel.Value;
					this.btnSave.EnabledButton = true;
					this.errError.SetVbecsError(updMinimumStockLevel, string.Empty); // **** 508 Compliance ***
					this.btnSave.SetToolTip(Common.StrRes.Tooltips.Common.OKToProceed().ResString);
				}
			}
			catch(FormatException)
			{
				this.btnSave.EnabledButton = false;
				this.btnSave.SetToolTip(Common.StrRes.SysErrMsg.Common.RangeError("Minimum stock level",updMinimumStockLevel.Minimum,updMinimumStockLevel.Maximum).ResString);
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmMaintainReagentMinLevels_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			string textToSpeak = "";

			if (this.btnSave.EnabledButton == false)
			{
				textToSpeak = this.btnSave.GetToolTip();
			}
			else if (this.btnOK.EnabledButton == false)
			{
				textToSpeak = this.btnOK.GetToolTip();
			}

			this.SpeakMessage( textToSpeak );		
		}

		#endregion
	}
}

